% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeOutput.R
\name{removeOutput}
\alias{removeOutput}
\title{Remove Output from Shiny Session}
\usage{
removeOutput(
  id,
  selector = paste0("#", id),
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Output value name}

\item{selector}{The HTML selector to remove the UI for. By default it is the
tag where the ID matches the output, but might need to be adjusted for
different inputs.}

\item{session}{The Shiny session to remove the output from}
}
\value{
An invisible `TRUE` value confirming that the output has been removed.
}
\description{
The removal of the named output in a shiny session.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shiny.destroy)

ui <- fluidPage(
  numericInput("number", "Select number:", 5, 1, 10),
  p("Selected number:", textOutput("number_out", inline = TRUE)),
  actionButton("delete", "Remove output")
)

server <- function(input, output, session) {
  output$number_out <- renderText(input$number)

  observeEvent(
    input$delete,
    removeOutput("number_out")
   )
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
