% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{TeachingBubble}
\alias{TeachingBubble}
\alias{TeachingBubbleContent}
\title{TeachingBubble}
\usage{
TeachingBubble(...)

TeachingBubbleContent(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A teaching bubble (\code{TeachingBubble}) brings attention to a new or important feature, with the goal of increasing engagement with the feature. A teaching bubble typically follows a coach mark.

Use teaching bubbles sparingly. Consider how frequently people will see it, and how many they’ll see across their entire experience.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/TeachingBubble}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ ariaDescribedBy } \code{string} \cr Defines the element id referencing the element containing the description for the TeachingBubble.
\item \bold{ ariaLabelledBy } \code{string} \cr Defines the element id referencing the element containing label text for TeachingBubble.
\item \bold{ calloutProps } \code{ICalloutProps} \cr Properties to pass through for Callout, reference detail properties in ICalloutProps
\item \bold{ componentRef } \verb{IRefObject<ITeachingBubble>} \cr Optional callback to access the ITeachingBubble interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ focusTrapZoneProps } \code{IFocusTrapZoneProps} \cr Properties to pass through for FocusTrapZone, reference detail properties in IFocusTrapZoneProps
\item \bold{ footerContent } \code{string | JSX.Element} \cr Text that will be rendered in the footer of the TeachingBubble. May be rendered alongside primary and secondary buttons.
\item \bold{ hasCloseButton } \code{boolean} \cr Whether the TeachingBubble renders close button in the top right corner.
\item \bold{ hasCloseIcon } \code{boolean} \cr
\item \bold{ hasCondensedHeadline } \code{boolean} \cr A variation with smaller bold headline and no margins.
\item \bold{ hasSmallHeadline } \code{boolean} \cr A variation with smaller bold headline and margins to the body. (\code{hasCondensedHeadline} takes precedence if it is also set to true.)
\item \bold{ headline } \code{string} \cr A headline for the Teaching Bubble.
\item \bold{ illustrationImage } \code{IImageProps} \cr An Image for the TeachingBubble.
\item \bold{ isWide } \code{boolean} \cr Whether or not the TeachingBubble is wide, with image on the left side.
\item \bold{ onDismiss } \verb{(ev?: any) => void} \cr Callback when the TeachingBubble tries to close.
\item \bold{ primaryButtonProps } \code{IButtonProps} \cr The Primary interaction button
\item \bold{ secondaryButtonProps } \code{IButtonProps} \cr The Secondary interaction button
\item \bold{ styles } \verb{IStyleFunctionOrObject<ITeachingBubbleStyleProps, ITeachingBubbleStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ target } \code{Target} \cr Element, MouseEvent, Point, or querySelector string that the TeachingBubble should anchor to.
\item \bold{ targetElement } \code{HTMLElement} \cr
\item \bold{ theme } \code{ITheme} \cr Theme provided by High-Order Component.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Teaching bubbles can be used in sequence to walk people through complex, multistep interactions only. And only show one teaching bubble at a time.
\item A maximum of no more than 3 sequenced teaching bubbles should be used in a single experience.
\item Sequenced teaching bubbles should have “x of y” text to indicate progress through the sequence. For example, the first teaching bubble in a sequence might be “1 of 3”.)
\item Always place the primary button on the left, the secondary button just to the right of it.
\item Show only one primary button that inherits theme color at rest state. In the event there are more than two buttons with equal priority, all buttons should have neutral backgrounds.
}
}

\subsection{Content}{

A teaching bubble should include:
\subsection{Title}{

You have 25 characters (including spaces) to draw people in and get them interested. Limit to one line of text, and use sentence casing (capitalize only the first word and any proper nouns) with no punctuation.
}

\subsection{Body copy}{

Lead with why the feature is useful rather than describe what it is. What does it make possible? Keep it within 120 characters (including spaces).
}

\subsection{Action buttons}{

Limit button labels to 15 characters (including spaces). Provide people with an explicit action to dismiss the teaching bubble, such as “Got it”. Include a secondary button to give people the option to take action, such as “Show me” or “Edit settings”. When two buttons are needed, make the call-to-action button the primary button and the dismissal button (such as “No thanks”) the secondary button. Use sentence casing (capitalize only the first word and any proper nouns) with no punctuation. On a sequenced teaching bubble, use "Next" for the action button label and "Got it" for the final sequenced teaching bubble action button with text that closes the experience.
}

\subsection{Link (Optional)}{

If there are additional steps people need to know about, or helpful information they may want to read, consider linking to a help article. Typically, these links are labeled “Learn more” with no punctuation at the end.
}

}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    DefaultButton.shinyInput(
      ns("toggleTeachingBubble"),
      id = "target",
      text = "Toggle TeachingBubble"
    ),
    reactOutput(ns("teachingBubble"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    showBubble <- reactiveVal(FALSE)
    observeEvent(input$toggleTeachingBubble, showBubble(!showBubble()))
    output$teachingBubble <- renderReact({
      if (showBubble()) {
        TeachingBubble(
          target = "#target",
          headline = "Very useful!"
        )
      }
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
