% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongo_connector.R
\name{mongo_tables_create}
\alias{mongo_tables_create}
\title{Create RegLog-valid database collections for MongoDB}
\usage{
mongo_tables_create(
  mongo_url,
  mongo_db,
  mongo_options = mongolite::ssl_options(),
  account_name = "account",
  reset_code_name = "reset_code",
  user_data = NULL,
  hash_passwords = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mongo_url}{URI to the MongoDB cluster}

\item{mongo_db}{name of the MongoDB database}

\item{mongo_options}{additional connection options such as SSL keys/certs}

\item{account_name}{Name of the collection for storing user accounts credentials.
Defaults to 'account'. Mandatory collection.}

\item{reset_code_name}{Name of the collector for storing generated password reset
codes. Defaults to 'reset_code'. Mandatory collection.}

\item{user_data}{If you wish to import existing user database, you can input
data.frame with that table in this argument. It should contain columns:
username, password, email (ond optionally: create_time). Defaults to NULL.}

\item{hash_passwords}{If you are importing table of users upon tables creation,
you can also specify if the password should be hashed using \code{scrypt::hashPassword}.
Defaults to \code{FALSE}. If you have unhashed passwords in imported table, set
this option to \code{TRUE}.}

\item{verbose}{Boolean specific if the actions made by function should be
printed back to the console.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

MongoDB database don't enforce a structure to the documents contained within.
Even though this is true, it's best to use this function explicitly,
as after creation of collections it also create appropriate indexes for quick
querying of the database by RegLogMongoConnector.
}
\details{
Every document in created collections will have following structure:
\itemize{
\item account (default name)
\itemize{
\item username: character \strong{(index)}
\item password: character
\item email: character \strong{(index)}
\item create_time: timestamp
\item update_time: timestamp
}
\item reset_code (default name)
\itemize{
\item user_id: character \strong{(index)}
\item reset_code: character
\item used: numeric
\item create_time: timestamp
\item update_time: timestamp
}
\item logs (default name, optional) - this collection isn't created with this
function, as there is no need for that - MongoDB collections don't have a
set structure, and no additional index is created there.
\itemize{
\item time: timestamp
\item session: character
\item direction: character
\item type: character
\item note: character
}
}
}
\seealso{
Other RegLog databases: 
\code{\link{DBI_tables_create}()},
\code{\link{gsheet_tables_create}()}
}
\concept{RegLog databases}
