% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twVarSelectInput.R
\name{twVarSelectInput}
\alias{twVarSelectInput}
\title{Wrapper around \code{\link[shiny:varSelectInput]{shiny::varSelectInput()}} but allowing for more classes}
\usage{
twVarSelectInput(
  inputId,
  label,
  data,
  selected = NULL,
  multiple = FALSE,
  selectize = TRUE,
  width = NULL,
  container_class = NULL,
  label_class = NULL,
  select_class = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{data}{A data frame. Used to retrieve the column names as choices for a \code{\link[shiny:selectInput]{selectInput()}}}

\item{selected}{The initially selected value (or multiple values if \code{multiple = TRUE}). If not specified then defaults to the first value for
single-select lists and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{selectize}{Whether to use \pkg{selectize.js} or not.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{select_class}{additional classes to be applied to the select elements}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:varSelectInput]{shiny::varSelectInput()}} but allowing for more classes
}
\examples{
shiny::varSelectInput("id", "label", mtcars,
  width = "200px",
  selected = c("vs", "cyl"), multiple = TRUE
)
twVarSelectInput("id", "label", mtcars,
  selected = c("vs", "cyl"), width = "200px",
  multiple = TRUE, selectize = TRUE,
  container_class = "CONTAINER", label_class = "LABEL",
  select_class = "SELECT"
)

# basic full shiny example
library(shiny)
# basic example
ui <- fluidPage(
  use_tailwind(),
  twVarSelectInput(
    "variable", "Variable to select:",
    mtcars,
    multiple = TRUE,
    # Apply tailwind classes
    container_class = "shadow-md rounded-md bg-gray-50 m-4 p-2 w-64",
    label_class = "font-serif",
    select_class = "font-mono font-bold text-red-800 rounded-md bg-stone-50"
  ),
  tableOutput("data")
)

server <- function(input, output) {
  output$data <- renderTable(
    {
      mtcars[[input$variable]]
    },
    rownames = TRUE
  )
}

if (interactive()) shiny::shinyApp(ui_basic, server)

}
\seealso{
\code{\link[shiny:varSelectInput]{shiny::varSelectInput()}}
}
