#' stepTimer
#'
#' Simulates a button press on `Step`.
#'
#' @param inputId character: input slot
#'
#' @return nothing
#' @importFrom shinyjs runjs
#' @export
#'
#' @examples
#' # Example requires the use of a `shiny` app (See Vignette)
#' if (interactive()) {
#'   library(shiny)
#'   library(shinyDTC)
#'   library(shinyjs)
#'
#'   ui <- fluidPage(
#'     useShinyjs(),
#'     timerUI("ttimer"),
#'     actionButton("step", "Trigger Step (Externally)")
#'   )
#'
#'   server <- function(input, output, session) {
#'     timerServer("ttimer")
#'
#'     observeEvent(input$step, {
#'       stepTimer("ttimer")
#'     })
#'   }
#'
#'   shinyApp(ui, server)
#' }
#'
#' \dontrun{
#' # stepTimer("ttimer") should be used inside a `shiny` server context
#' }
stepTimer <- function(inputId) {
  runjs(sprintf("$('#%s').click();", paste0(inputId, '_step')))
}
