% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_build_light.R
\name{plotly_build_light}
\alias{plotly_build_light}
\title{Build \code{plotly} data with low computation cost}
\usage{
plotly_build_light(fig, vars_hf = c("x", "y", "text", "hovertext"))
}
\arguments{
\item{fig}{\code{plotly} object.
Note that \code{fig$x$attrs} is not \code{NULL} and
each \code{fig$x$attrs} element has an element named \code{x}.
This function generates \code{fig$x$data} using \code{fig$x$attrs}.}

\item{vars_hf}{Character, optional.
Variable names where high frequency data is included.
It must include \code{x}.}
}
\value{
built \code{plotly} object
}
\description{
Before illustrating data using \code{plotly}, it must be built
(\code{figure$x$data} are need to be made using \code{figure$x$attrs}).
However, because a lot of procedures are necessary,
the computation cost is relatively high.
With this function, the data is built in quite short time by omitting
several procedures for high-frequency data.
Note that this function is not universally applicable to all \code{plotly}
objects but made for high-frequency scatter data.
\code{plotly::plotly_build} function may return better results in
specific cases although it takes more time.
}
\examples{
data(noise_fluct)
plotly_build_light(
  plotly::plot_ly(
    x = noise_fluct$time,
    y = noise_fluct$f500,
    name = "level",
    type = "scatter"
  )
)

plotly_build_light(
  plotly::plot_ly(
    data = noise_fluct,
    x = ~time,
    y = ~f500,
    name = "level",
    type = "scatter"
  )
)

}
