% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{accordion}
\alias{accordion}
\alias{accordion_item}
\alias{update_accordion}
\title{accordion}
\usage{
accordion(inputId, ..., value = default_value)

accordion_item(...)

update_accordion(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI accordion component.
}
\description{
Accordion display a list of high-level options that can expand/collapse to reveal more information.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode OR ReactNode[]}. Default: \code{NA}.
\item \bold{variant}. Type: \code{light OR shadow OR bordered OR splitted}. Default: \code{"light"}.
\item \bold{selectionMode}. Type: \code{none OR single OR multiple}. Default: \code{NA}.
\item \bold{selectionBehavior}. Type: \code{toggle OR replace}. Default: \code{"toggle"}.
\item \bold{isCompact}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showDivider}. Type: \code{boolean}. Default: \code{true}.
\item \bold{dividerProps}. Type: \code{DividerProps}. Default: \code{NA}.
\item \bold{hideIndicator}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableIndicatorAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disallowEmptySelection}. Type: \code{boolean}. Default: \code{false}.
\item \bold{keepContentMounted}. Type: \code{boolean}. Default: \code{false}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{true}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{disabledKeys}. Type: \code{React.Key[]}. Default: \code{NA}.
\item \bold{itemClasses}. Type: \code{AccordionItemClassnames}. Default: \code{NA}.
\item \bold{selectedKeys}. Type: \code{all OR React.Key[]}. Default: \code{NA}.
\item \bold{defaultSelectedKeys}. Type: \code{all OR React.Key[]}. Default: \code{NA}.
}
\itemize{
\item \bold{onSelectionChange}. Type: \code{(keys: "all" OR Set<React.Key>) => any}. Default: \code{NA}.
}
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{title}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{subtitle}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{indicator}. Type: \code{IndicatorProps}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{isCompact}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{keepContentMounted}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideIndicator}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableIndicatorAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{HeadingComponent}. Type: \code{React.ElementType}. Default: \code{"h2"}.
\item \bold{classNames}. Type: \code{AccordionItemClassnames}. Default: \code{NA}.
}
\itemize{
\item \bold{onFocus}. Type: \code{(e: FocusEvent) => void}. Default: \code{NA}.
\item \bold{onBlur}. Type: \code{(e: FocusEvent) => void}. Default: \code{NA}.
\item \bold{onFocusChange}. Type: \code{(isFocused: boolean) => void}. Default: \code{NA}.
\item \bold{onKeyDown}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onKeyUp}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onPress}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressStart}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressEnd}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressChange}. Type: \code{(isPressed: boolean) => void}. Default: \code{NA}.
\item \bold{onPressUp}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onClick}. Type: \code{MouseEventHandler}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  debug_react = TRUE,
  p(class = "font-extrabold text-2xl uppercase", "accordion()"),
  accordion(
    inputId = "accordion1",
    value = "2",
    accordion_item(
      startContent = avatar(
        isBordered = TRUE,
        color = "primary",
        radius = "lg",
        src = "https://i.pravatar.cc/150?u=a042581f4e29026024d"
      ),
      onPress = JS("(e) => alert('Your pressed me')"),
      "plop",
      title = "Element 1",
      key = "1",
      subtitle = "subtitle"
    ),
    accordion_item("plop", title = "Element 2", key = "2")
  ),
  spacer(y = 2),
  p(class = "font-extrabold text-2xl uppercase", "shadow variant accordion()"),
  accordion(
    inputId = "accordion2",
    isCompact = TRUE,
    variant = "shadow",
    value = "3",
    accordion_item("plop", title = "Element 1", key = "1", subtitle = "subtitle"),
    accordion_item("plop", title = "Element 2", key = "2"),
    accordion_item("plop", title = "Element 3", key = "3")
  ),
  spacer(y = 2),
  p(class = "font-extrabold text-2xl uppercase", "bordered variant accordion()"),
  accordion(
    inputId = "accordion3",
    isCompact = TRUE,
    variant = "bordered",
    accordion_item("plop", title = "Element 1", key = "1", subtitle = "subtitle"),
    accordion_item("plop", title = "Element 2", key = "2")
  ),
  spacer(y = 2),
  p(class = "font-extrabold text-2xl uppercase", "splitted variant accordion()"),
  accordion(
    inputId = "accordion4",
    isCompact = TRUE,
    variant = "splitted",
    motionProps= JS(
      '{
      variants: {
        enter: {
          y: 0,
          opacity: 1,
          height: "auto",
          transition: {
            height: {
              type: "spring",
              stiffness: 500,
              damping: 30,
              duration: 1,
            },
            opacity: {
              easings: "ease",
              duration: 1,
            },
          },
        },
        exit: {
          y: -10,
          opacity: 0,
          height: 0,
          transition: {
            height: {
              easings: "ease",
              duration: 0.25,
            },
            opacity: {
              easings: "ease",
              duration: 0.3,
            },
          },
        },
      },
    }'),
    value = "2",
    accordion_item("plop", title = "Element 1", key = "1", subtitle = "subtitle"),
    accordion_item("plop", title = "Element 2", key = "2")
  ),
  spacer(y = 2),
  p(class = "font-extrabold text-2xl uppercase", "Update accordion"),
  select_input(
    "select",
    label = "Accordion to open:",
    select_item(key = 1, value = "1", "1"),
    select_item(key = 2, value = "2", "2")
  ),
  spacer(y = 2),
  accordion(
    inputId = "accordion5",
    isCompact = TRUE,
    variant = "bordered",
    accordion_item("plop1", title = "Element 1", key = "1", subtitle = "subtitle"),
    accordion_item("plop2", title = "Element 2", key = "2")
  )
)

server <- function(input, output, session) {
  observeEvent(input$select, {
    update_accordion(
      session,
      "accordion5",
      value = input$select
    )
  })
  observe(
    print(input$accordion1)
  )
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/accordion}.
}
