% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{checkboxgroup_input}
\alias{checkboxgroup_input}
\alias{update_checkboxgroup_input}
\title{Checkbox group input}
\usage{
checkboxgroup_input(inputId, ..., choices, selected = NULL)

update_checkboxgroup_input(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...,
  choices = NULL,
  selected = NULL
)
}
\arguments{
\item{inputId}{Unique input id.}

\item{...}{Props.}

\item{choices}{Radio choices.}

\item{selected}{Default selected value.}

\item{session}{Shiny session.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
Checkbox group input
}
\details{
See \url{https://heroui.com/docs/components/checkbox-group}
to get the list of parameters to pass in \code{...}.
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  debug_react = TRUE,
  div(
    class = "flex flex-col gap-1",
    spacer(y = 2),
    select_input(
      "select",
      label = "Tab to select:",
      value = JS("['sydney']"),
      selectionMode = "multiple",
      select_item(key = "buenos-aires", value = "buenos-aires", "Buenos Aires"),
      select_item(key = "sydney", value = "sydney", "Sydney")
    ),
    checkboxgroup_input(
      inputId = "checkbox_group",
      label = "Checkbox Group",
      choices = c(
        "buenos-aires" = "Buenos Aires",
        "sydney" = "Sydney"
      ),
      orientation = "horizontal",
      color = "secondary"
    ),
    textOutput("checkbox_group_val")
  )
)

server <- function(input, output, session) {
  observeEvent(input$select, {
    update_checkboxgroup_input(session, "checkbox_group", selected = input$select)
  }, ignoreNULL = FALSE)
  output$checkbox_group_val <- renderText(input$checkbox_group)
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/checkbox-group}.
}
