% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{dropdow_menu}
\alias{dropdow_menu}
\alias{dropdown_item}
\alias{dropdown_section}
\alias{update_dropdown}
\title{Dropdown menu}
\usage{
dropdow_menu(inputId, ..., choices = NULL, selected = NULL)

dropdown_item(...)

dropdown_section(...)

update_dropdown(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{Unique input id.}

\item{...}{Props.}

\item{choices}{Radio choices.}

\item{selected}{Default selected value.}

\item{session}{Shiny session.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
Dropdown menu
}
\details{
See \url{https://heroui.com/docs/components/dropdown}
to get the list of parameters to pass in \code{...}.
}
\note{
Container for related \link{dropdown_item}.
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

items <- list(
  # Dropdown section
  dropdown_section(
    showDivider = TRUE,
    title = "Section 1",
    # Dropdown Items
    list(
      dropdown_item(
        title = "Item 1",
        shortcut = "\u2318N",
        color = "danger",
        description = "Item description",
        startContent = icon("clock")
      ),
      dropdown_item(
        title = "Item 2",
        shortcut = "\u2318N",
        color = "success",
        description = "Item description",
        startContent = icon("home")
      ),
      dropdown_item(
        title = "External link",
        href = "https://heroui.com/",
        target = "_blank",
        description = "Go to nextui documentation"
      )
    )
  ),
  dropdown_section(
    showDivider = FALSE,
    title = "Section 2",
    # Dropdown Items
    list(
      dropdown_item(
        title = "Item 3",
        color = "warning",
        description = "Item description"
      ),
      dropdown_item(
        title = "Item 4"
      )
    )
  )
)

# You can also skip section
#items <- list(
#  dropdown_item(
#    title = "Item 1",
#    shortcut = "\u2318N",
#    color = "danger",
#    description = "Item description"#,
#    #startContent = icon("clock")
#  ),
#  dropdown_item(
#    title = "Item 2",
#    shortcut = "\u2318N",
#    color = "success",
#    description = "Item description"#,
#    #startContent = icon("home")
#  )
#)

ui <- nextui_page(
  debug_react = TRUE,
  div(
    class = "flex gap-2 my-2",
    dropdow_menu(
      inputId = "dropdown",
      label = "Dropdown menu",
      selected = "Item 2",
      variant = "bordered",
      disabledKeys = c("Item 3", "Item 4"),
      selectionMode = "multiple",
      choices = items
    )
  ),
  verbatimTextOutput("dropdown_val")
)

server <- function(input, output, session) {
  observe({
    print(input$dropdown)
  })
  output$dropdown_val <- renderText(input$dropdown)
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/dropdown}.
}
