% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_switcher}
\alias{theme_switcher}
\title{Theme switcher helper}
\usage{
theme_switcher(
  value = TRUE,
  label = "Change theme",
  startContent = sun_icon(),
  endContent = moon_icon()
)
}
\arguments{
\item{value}{Switch status.}

\item{label}{Input label.}

\item{startContent}{Icon when selected.}

\item{endContent}{Icon when not selected.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Change between light and dark mode
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyNextUI)
  library(shiny.react)

  ui <- nextui_page(
    theme_switcher(),
    card(card_body("My card"))
  )

  server <- function(input, output, session) {
    observe({
      print(input$theme)
    })
  }

  shinyApp(ui, server)

}
}
