% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_all_info}
\alias{get_all_info}
\title{Get all information about user's browser}
\usage{
get_all_info()
}
\value{
List with all information detected about the user's browser: \code{device}, \code{browser},
\code{os}, \code{dimensions}, \code{user_agent}
}
\description{
Get a list with all the information detected about the user's browser.\cr\cr
The list is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\section{Accuracy}{

It's important to understand there is no reliable way to detect the
information in \{shinybrowser\} with 100\% accuracy.\cr\cr\{shinybrowser\} makes
a best effort at identifying the most accurate information, but some
browser/operating system combinations may be difficult to identify. Users
can also use a variety of tools to deliberately spoof this information.\cr\cr
With that in mind, \{shinybrowser\} should detect the correct information in
most cases.
}

\section{Supported values}{

Only major browsers and operating systems are supported, which means that the
RStudio Viewer may result in an "UNKNOWN" browser, and unpopular operating systems
may also result in "UNKNOWN".\cr\cr
For a list of values that can be detected, see \link{SUPPORTED_BROWSERS},
\link{SUPPORTED_DEVICES}, and \link{SUPPORTED_OPERATING_SYSTEMS}.
}

\section{Mobile vs desktop vs tablet}{

\{shinybrowser\} attempts to detect whether a device is "mobile" or "desktop".
The distinction between mobile and desktop is not always clear, so if what you
actually care about is the size of the device, it might be better to use
\code{\link[=get_width]{get_width()}}.\cr\cr
Tablets return ambiguous results; some tablets self-report as mobile devices while
others as desktop.
}

\section{Width and height}{

The width and height of the browser window are only reported once, when the \code{\link[=detect]{detect()}}
function is initially called.
If the user resizes the browser window, the new dimensions are not reported until
the page is refreshed.
}

\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your browser information:",
    verbatimTextOutput("browser_info")
  )
  server <- function(input, output, session) {
    output$browser_info <- renderPrint({
      shinybrowser::get_all_info()
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_browser]{get_browser()}}, \code{\link[=get_browser_version]{get_browser_version()}}, \code{\link[=get_os]{get_os()}}, \code{\link[=get_os_version]{get_os_version()}},
\code{\link[=get_device]{get_device()}}, \code{\link[=get_width]{get_width()}}, \code{\link[=get_height]{get_height()}}, \code{\link[=get_user_agent]{get_user_agent()}},
\link{SUPPORTED_BROWSERS}, \link{SUPPORTED_DEVICES}, \link{SUPPORTED_OPERATING_SYSTEMS}
}
