% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_user_agent}
\alias{get_user_agent}
\title{Get user agent string from the browser}
\usage{
get_user_agent()
}
\value{
User's user-agent string
}
\description{
This function exposes the user agent that is reported by the browser, but it
should only be used for troubleshooting purposes.\cr\cr
The value is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your user agent:",
    textOutput("ua_info")
  )
  server <- function(input, output, session) {
    output$ua_info <- renderText({
      shinybrowser::get_user_agent()
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_all_info]{get_all_info()}}
}
