% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{block_output}
\alias{block_output}
\title{Block an output}
\usage{
block_output(
  output,
  type = c("standard", "hourglass", "circle", "arrows", "dots", "pulse"),
  text = "Loading...",
  timeout = 0,
  ...,
  minHeight = NULL
)
}
\arguments{
\item{output}{An output element.}

\item{type}{Type of blocking indicator.}

\item{text}{Text displayed below the blocking indicator. Must be a single character string.}

\item{timeout}{Unblock after a delay.}

\item{...}{Other configuration option, see \href{https://notiflix.github.io/documentation#DocsBlock}{online documentation}.}

\item{minHeight}{Set a minimal height to the ouptut element.}
}
\value{
A \code{shiny.tag} or \code{shiny.tag.list} object (the \code{output} element modified).
}
\description{
Block an output until it is recalculated.
}
\examples{
library(shinybusy)
library(shiny)

ui <- fluidPage(
  tags$h3("Block Output from UI"),
  actionButton("refresh", "Refresh outputs"),
  actionButton("open_modal", "Open modal"),
  fluidRow(
    column(
      width = 4,
      block_output(plotOutput(outputId = "plot1"))
    ),
    column(
      width = 4,
      block_output(
        plotOutput(outputId = "plot2"),
        type = "hourglass",
        messageColor = "#FFF",
        svgColor = "#FFF",
        svgSize = "70px",
        backgroundColor = "#5ea4d8"
      )
    ),
    column(
      width = 4,
      plotOutput(outputId = "plot3")
    )
  )
)

server <- function(input, output, session) {

  output$plot1 <- renderPlot({
    input$refresh
    barplot(table(floor(runif(100) * 6)))
  })

  data_r <- reactive({
    input$refresh
    Sys.sleep(3)
    data <- data.frame(x = rnorm(50), y = rnorm(50))
    return(data)
  })

  output$plot2 <- renderPlot({
    plot(data_r())
  })

  output$plot3 <- renderPlot({
    plot(data_r(), main = "Not blocked")
  })


  observeEvent(input$open_modal, {
    showModal(modalDialog(
      block_output(plotOutput(outputId = "plot_modal")),
      actionButton("refresh_modal", "Refresh plot")
    ))
  })

  output$plot_modal <- renderPlot({
    input$refresh_modal
    Sys.sleep(1)
    barplot(table(floor(runif(100) * 6)))
  })
}

if (interactive())
  shinyApp(ui, server)

}
