% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderInput.R
\name{orderInput}
\alias{orderInput}
\title{Create a shiny input control to show the order of a set of items}
\usage{
orderInput(
  inputId,
  label,
  items,
  as_source = FALSE,
  connect = NULL,
  item_class = c("default", "primary", "success", "info", "warning", "danger"),
  placeholder = NULL,
  width = "500px",
  legacy = FALSE,
  ...
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the current order
of items.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{items}{Items to display, can be a list, an atomic vector or a factor.
For list or atomic vector, if named, the names are displayed and the order
is given in values. For factor, values are displayed and the order is given
in levels}

\item{as_source}{A boolean value to determine whether the \code{orderInput} is set
as source mode. Only works if the \code{connect} argument was set.}

\item{connect}{Optional. Allow items to be dragged between \code{orderInput}s.
Should be a vector of \code{inputId}(s) of other \code{orderInput}(s) that the items
from this \code{orderInput} should be connected to.}

\item{item_class}{One of the \href{https://getbootstrap.com/docs/4.0/utilities/colors/}{Bootstrap color utility classes} to apply to
each item.}

\item{placeholder}{A character string to show when there is no item left in
the \code{orderInput}.}

\item{width}{The width of the input, e.g. '400px', or '100\\%'. Passed to
\link[shiny:reexports]{shiny::validateCssUnit}.}

\item{legacy}{A boolean value. Whether to use the old version of the
\code{orderInput} function.}

\item{...}{Arguments passed to \code{shiny::tags$div} which is used to build the
container of the \code{orderInput}.}
}
\value{
An \code{orderInput} control that can be added to a UI definition.
}
\description{
Display a set of items whose order can be changed by drag and drop inside or
between \code{orderInput}(s). The item order is send back to server in the from of
\code{input$inputId}.
}
\details{
\code{orderInput}s can work in either connected mode or stand-alone mode. In
stand-alone mode, items can only be drag and drop inside the input control.
In connected mode, items to be dragged between \code{orderInput}s, which is
controlled by the \code{connect} parameter. This is a one-way relationship. To
connect items in both directions, the \code{connect} parameter must be set in both
\code{orderInput}s.

When in connected mode, \code{orderInput} can be set as source-only through the
\code{as_source} parameter. The items in a "source" \code{orderInput} can only be
copied, instead of moved, to other connected non-source \code{orderInput}(s). From
shinyjqui v0.4.0, A "source" \code{orderInput} will become a "recycle bin" for
items from other \code{orderInput}s as well. This means, if you want to delete an
item, you can drag and drop it into a "source" \code{orderInput}. This feature can
be disabled by setting the \code{options} of non-source \code{orderInput}(s) as
\code{list(helper = "clone")}.

From shinyjqui v0.4.0 and above, the \code{orderInput} function was implemented in
the similar way as other classical shiny inputs, which brought two changes:
\enumerate{
\item The input value was changed from \code{input$inputId_order} to \code{input$inputId};
\item The new version supports \link{updateOrderInput} function which works in the
same way as other shiny input updater functions. To keep the backward
compatibility, a \code{legacy} argument was provided if user wanted to use the old
version.
}
}
\examples{
orderInput('items1', 'Items1', items = month.abb, item_class = 'info')

## build connections between orderInputs
orderInput('items2', 'Items2 (can be moved to Items1 and Items4)', items = month.abb,
           connect = c('items1', 'items4'), item_class = 'primary')

## build connections in source mode
orderInput('items3', 'Items3 (can be copied to Items2 and Items4)', items = month.abb,
           as_source = TRUE, connect = c('items2', 'items4'), item_class = 'success')

## show placeholder
orderInput('items4', 'Items4 (can be moved to Items2)', items = NULL, connect = 'items2',
           placeholder = 'Drag items here...')
}
