% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_report.R
\name{shinyloadtest_report}
\alias{shinyloadtest_report}
\title{Make shinyloadtest Report}
\usage{
shinyloadtest_report(
  df,
  output = "shinyloadtest_report.html",
  duration_cutoff = c(attr(df, "recording_duration"), 60)[1],
  http_latency_cutoff = 5,
  max_websocket_cutoff = 20,
  open_browser = TRUE,
  self_contained = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{df}{data.frame returned from \code{\link[=load_runs]{load_runs()}}}

\item{output}{File where HTML output should be saved}

\item{duration_cutoff}{Cutoff value for session duration plot. Defaults to the recording duration used to simulate \code{df} or 60 seconds.}

\item{http_latency_cutoff}{Cutoff value for total http latency plot}

\item{max_websocket_cutoff}{Cutoff value for max websocket latency plot}

\item{open_browser}{Whether to open the created output in the browser}

\item{self_contained}{Boolean that determines if the final output should be a self contained html file}

\item{verbose}{Boolean that determines if progress output is displayed}
}
\value{
The path to the report, invisibly
}
\description{
Make shinyloadtest Report
}
\examples{
\dontrun{
shinyloadtest_report(slt_demo_data_1)
}
}
