% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{store_googledrive}
\alias{store_googledrive}
\title{Use Google Drive as storage mode}
\usage{
store_googledrive(path)
}
\arguments{
\item{path}{Path to folder on Drive where to send logs.}
}
\value{
A list that can be used in \code{\link[=track_usage]{track_usage()}}.
}
\description{
All logs will be written in the same file.
}
\note{
See the {gargle} package to manage authentication, and especially
\href{https://gargle.r-lib.org/articles/articles/managing-tokens-securely.html}{this vignette from {gargle} package} to manage the process.
}
\examples{
\dontrun{
# In your global, manage Google Drive access
drive_auth(path = "/path/to/your/service-account-token.json")
# see https://gargle.r-lib.org/articles/articles/managing-tokens-securely.html
# to manage your token securely

# Then in server, use:
track_usage(storage_mode = store_googledrive(path = "my-logs/"))

# you may have to share my-logs/ folder with your service account

}
}
