% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_mod.R
\name{delete_mod}
\alias{delete_mod}
\title{Deletes a module from the database}
\usage{
delete_mod(modName, shinyMgrPath, fileDelete = FALSE, 
verbose = TRUE)
}
\arguments{
\item{modName}{The name of the module to be deleted, character string.}

\item{shinyMgrPath}{The path to the shinymgr project. Typically the working 
directory.}

\item{fileDelete}{TRUE/FALSE, whether the module script should also be 
deleted - defaults to FALSE.}

\item{verbose}{Whether to print updates to the console (default = TRUE)}
}
\value{
An integer value with the total number of rows deleted (including 
cascades)
}
\description{
Deletes a module (and associated files if requested) from the 
shinymgr.sqlite database
}
\section{More Info}{

The delete_mod() function is described in the "shinymgr_modules" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other delete: 
\code{\link{delete_app}()},
\code{\link{delete_report}()}
}
\concept{delete}
