% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cars_bag_vfld}
\alias{cars_bag_vfld}
\title{Resampled bagged tree results}
\value{
An object with primary class \code{resample_results}.
}
\description{
This object has the results when a bagged regression tree was resampled using
10-fold cross-validation.
}
\details{
The code used to produce this object:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  library(tidymodels)
  library(baguette)
  tidymodels_prefer()

  # ------------------------------------------------------------------------------

  ctrl_rs <- control_resamples(save_pred = TRUE)

  # ------------------------------------------------------------------------------

  set.seed(1)
  cars_rs <- vfold_cv(mtcars)

  cars_bag_vfld <-
    bag_tree() \%>\%
    set_engine("rpart", times = 5) \%>\%
    set_mode("regression") \%>\%
    fit_resamples(
      mpg ~ .,
      resamples = cars_rs,
      control = ctrl_rs
    )
}\if{html}{\out{</div>}}
}
\keyword{datasets}
