% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-biomass.R
\name{eq_biomass_cudjoe_2024}
\alias{eq_biomass_cudjoe_2024}
\title{Biomass equations for 2 species in Castille and León (Spain)}
\usage{
eq_biomass_cudjoe_2024(species, component = "AGB", return_rmse = FALSE)
}
\arguments{
\item{species}{A character string specifying the scientific name of the tree
species. It can be a column name if all the species are included in this model.
See Details for available species.}

\item{component}{A character string specifying the tree component for biomass
calculation (e.g., "stem", "branches"). See Details.}

\item{return_rmse}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}
}
\value{
A S7 list of parameters
}
\description{
Allometric equations adjusted for \emph{Quercus petraea}, and \emph{Pinus sylvestris}
in Castille and León (Spain)
}
\details{
There are three species options in this model:
\itemize{
\item \emph{\strong{Quercus petraea}}
\item \emph{\strong{Pinus sylvestris}}
\item \strong{Mixed}: stands with \emph{Quercus petraea} and \emph{Pinus sylvestris}
}

The tree components include some AGB components:
\itemize{
\item \strong{leaves}: only for \emph{P. sylvestris}
\item \strong{stem}: for all species
\item \strong{medium branches and small brances}: for all species
\item \strong{thick branches}: for all species
\item \strong{AGB}: total biomass, results of summing the previous components
}
}
\examples{
## get model parameters for silv_predict_biomass
eq_biomass_cudjoe_2024("mixed", "AGB")
}
\seealso{
\code{\link[=silv_predict_biomass]{silv_predict_biomass()}}, \link{biomass_models}, \code{\link[=eq_biomass_montero_2005]{eq_biomass_montero_2005()}}, \code{\link[=eq_biomass_dieguez_aranda_2009]{eq_biomass_dieguez_aranda_2009()}}
\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}, \code{\link[=eq_biomass_ruiz_peinado_2012]{eq_biomass_ruiz_peinado_2012()}}, \code{\link[=eq_biomass_manrique_2017]{eq_biomass_manrique_2017()}},
\code{\link[=eq_biomass_menendez_2022]{eq_biomass_menendez_2022()}}
}
