% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empSignificant.R
\name{empSignificant}
\alias{empSignificant}
\title{Empirical Significance for a List of Simulated Trials}
\usage{
empSignificant(simTrials, criticalPFS, criticalOS, eventNumPFS, eventNumOS)
}
\arguments{
\item{simTrials}{(\code{list})\cr simulated trial data sets, see \code{\link[=getClinicalTrials]{getClinicalTrials()}}.}

\item{criticalPFS}{(positive \code{number})\cr critical value of the log-rank test for PFS.}

\item{criticalOS}{(positive \code{number})\cr critical value of the log-rank test for OS.}

\item{eventNumPFS}{(\code{integer})\cr number of PFS events required to trigger PFS analysis.}

\item{eventNumOS}{(\code{integer})\cr number of OS events required to trigger OS analysis.}
}
\value{
This returns values of four measures of empirical significance.
}
\description{
This function computes four types of empirical significance — PFS, OS, at-least (significant
in at least one of PFS/OS), and joint (significant in both PFS and OS) — using
the log-rank test. Empirical significance is calculated as the proportion of significant
results in simulated trials, each ending when a set number of PFS/OS events occur.
Critical values for PFS and OS test significance must be specified. If trials simulate equal
transition hazards across groups (H0), empirical significance estimates type I error;
if they simulate differing transition hazards (H1), it estimates power.
}
\examples{
transition1 <- exponential_transition(h01 = 0.06, h02 = 0.3, h12 = 0.3)
transition2 <- exponential_transition(h01 = 0.1, h02 = 0.4, h12 = 0.3)
simTrials <- getClinicalTrials(
  nRep = 50, nPat = c(800, 800), seed = 1234, datType = "1rowPatient",
  transitionByArm = list(transition1, transition2), dropout = list(rate = 0.5, time = 12),
  accrual = list(param = "intensity", value = 7)
)
empSignificant(
  simTrials = simTrials, criticalPFS = 2.4, criticalOS = 2.2,
  eventNumPFS = 300, eventNumOS = 500
)
}
