% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.t}
\alias{analyze.simstudy.t}
\title{analyze.simstudy.t}
\usage{
analyze.simstudy.t(
  test.statistics.t,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.t}{Summary information for fitting one-sample t tests.  Structure is in the form returned by the function simitation::sim.t.test().}

\item{alternative}{See help(t.test).}

\item{conf.level}{See help(t.test)}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}
}
\value{
A list containing the following elements:
\itemize{
  \item estimate.summary: Summary statistics for the estimate.
  \item stat.summary: Summary statistics for the t-test statistic.
  \item p.value.summary: Data frame with proportions of tests that rejected and did not reject the null hypothesis.
  \item ci.range.summary: Summary statistics for the confidence interval range.
  \item ci.proportion.above.null.summary: Summary statistics for the proportion of the upper confidence limit above the null value.
  \item ci.proportion.below.null.summary: Summary statistics for the proportion of the lower confidence limit below the null value.
  \item ci.limit.summary: (Only if `alternative` is "greater" or "less") Summary statistics for either the lower or upper confidence limit, depending on the specified alternative.
}
}
\description{
analyze.simstudy.t
}
\examples{


simdat.t <- sim.t(n = 25, mean = 0.3, sd = 1,  num.experiments = 2,
experiment.name = "experiment", value.name = "x", seed = 2187)


test.statistics.t <- sim.t.test(simdat.t = simdat.t, alternative = "greater",
 mu = 0, conf.level = 0.95, experiment.name = "experiment", value.name = "x")

analysis.t <- analyze.simstudy.t(test.statistics.t = test.statistics.t,
conf.level = 0.95, alternative = "greater", the.quantiles =
c(0.025, 0.25, 0.25, 0.5, 0.75, 0.975))
}
