% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.t2}
\alias{analyze.simstudy.t2}
\title{analyze.simstudy.t2}
\usage{
analyze.simstudy.t2(
  test.statistics.t2,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.t2}{Summary information for fitting two-sample t tests.  Structure is in the form returned by the function simitation::sim.t2.test().}

\item{alternative}{See help(t.test).}

\item{conf.level}{See help(t.test)}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}
}
\value{
A list containing the following elements:
\itemize{
  \item estimate.summary: Summary statistics for the estimate.
  \item stat.summary: Summary statistics for the t-test statistic.
  \item df.summary: Summary statistics for the degrees of freedom.
  \item p.value.summary: Data frame with proportions of tests that rejected and did not reject the null hypothesis.
  \item ci.range.summary: Summary statistics for the confidence interval range.
  \item ci.proportion.above.null.summary: Summary statistics for the proportion of the upper confidence limit above the null value.
  \item ci.proportion.below.null.summary: Summary statistics for the proportion of the lower confidence limit below the null value.
  \item ci.limit.summary: Summary statistics for either the lower or upper confidence limit, depending on the specified alternative.
}
}
\description{
analyze.simstudy.t2
}
\examples{

simdat.t2 <- sim.t2(nx = 30, ny = 40, meanx = 0, meany = 0.2, sdx = 1,
 sdy = 1, num.experiments = 2, experiment.name = "experiment",
 group.name = "group", x.value = "x", y.value = "y", value.name = "value",
 seed = 17)


test.statistics.t2 <- sim.t2.test(simdat.t2 = simdat.t2,
alternative = "less", mu = 0, conf.level = 0.9,
experiment.name = "experiment", group.name = "group",
x.value = "x", y.value = "y", value.name = "value")

analysis.t2 <- analyze.simstudy.t2(test.statistics.t2 =
test.statistics.t2, alternative = "less", conf.level = 0.9,
the.quantiles = c(0.25, 0.5, 0.75))
}
