% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.t.test}
\alias{sim.t.test}
\title{sim.t.test}
\usage{
sim.t.test(
  simdat.t,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95,
  experiment.name = "experiment",
  value.name = "x"
)
}
\arguments{
\item{simdat.t}{Data for use in one-sample t tests across one or more experiments.  Structure is in the form returned by the function simitation::sim.t().}

\item{alternative}{See help(t.test).}

\item{mu}{See help(t.test)}

\item{paired}{See help(t.test)}

\item{var.equal}{See help(t.test)}

\item{conf.level}{See help(t.test)}

\item{experiment.name}{A character value providing the name of the column identifying the experiment.}

\item{value.name}{A character value providing the name of the column identifying the values.}
}
\value{
A data frame or data.table containing the results of one-sample t-tests
        performed on the data generated by the 'sim.t' function.
}
\description{
sim.t.test
}
\examples{

simdat.t <- sim.t(n = 25, mean = 0.3, sd = 1,  num.experiments = 2,
experiment.name = "experiment", value.name = "x", seed = 2187)


test.statistics.t <- sim.t.test(simdat.t = simdat.t, alternative = "greater",
mu = 0, conf.level = 0.95, experiment.name = "experiment", value.name = "x")
}
