% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{get_n_generated}
\alias{get_n_generated}
\alias{get_trajectory}
\alias{get_name}
\alias{get_start_time}
\alias{get_attribute}
\alias{get_global}
\alias{get_prioritization}
\alias{get_batch_size}
\title{Get Process Parameters}
\usage{
get_n_generated(.env, sources)

get_trajectory(.env, sources)

get_name(.env)

get_start_time(.env)

get_attribute(.env, keys)

get_global(.env, keys)

get_prioritization(.env)

get_batch_size(.env)
}
\arguments{
\item{.env}{the simulation environment.}

\item{sources}{one or more resource names.}

\item{keys}{the attribute name(s).}
}
\description{
Getters for processes (sources and arrivals) number of arrivals generated
by a source, the name of the active arrival, an attribute from the active
arrival or a global one, prioritization values, or the number of arrivals
in an active batch.
}
\details{
\code{get_n_generated} returns the number of arrivals generated by
the given sources. \code{get_trajectory} returns the trajectory to which they
are attached (as a list).

\code{get_name} returns the number of the running arrival.
\code{get_start_time} returns the start time of the running arrival.
\code{get_attribute} returns a running arrival's attributes.
If a provided key was not previously set, it returns a missing value.
\code{get_global} returns a global attribute.
\code{get_prioritization} returns a running arrival's prioritization values.
\code{get_name}, \code{get_start_time}, \code{get_attribute} and
\code{get_prioritization} are meant to be used inside a trajectory; otherwise,
there will be no arrival running and these functions will throw an error.
}
\seealso{
\code{\link{get_sources}}, \code{\link{set_trajectory}},
\code{\link{set_attribute}}, \code{\link{set_global}},
\code{\link{set_prioritization}}, \code{\link{batch}}.
}
