% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteCache.R
\name{deleteCaches}
\alias{deleteCaches}
\title{Deletes caches}
\usage{
deleteCaches(cacheNames, cacheDir = getCacheDir(), force = FALSE)
}
\arguments{
\item{cacheNames}{Name(s) of the cache to delete}

\item{cacheDir}{Directory where caches are kept}

\item{force}{Force deletion without user prompt}
}
\description{
Given a cache name, this function will attempt to delete the cache of that
name on disk.
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
