% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigraphs.R
\name{remove_multiple}
\alias{remove_multiple}
\title{Remove multiple edges from a graph}
\usage{
remove_multiple(graph)
}
\arguments{
\item{graph}{Input graph.}
}
\value{
Graph, without the multiple edges. (More precisely, from
  each set of multiple edges, only one, the first one, is kept.)
}
\description{
Remove multiple edges from a graph
}
\examples{
G <- graph(list(A = c("A", "B", "B"), B = c("A", "C"), C = "A"))
is_multigraph(G)
is_multigraph(remove_multiple(G))
}
\seealso{
Other multigraphs: 
\code{\link{is_loopy}()},
\code{\link{is_multigraph}()},
\code{\link{is_simple}()},
\code{\link{remove_loops}()},
\code{\link{simplify}()}
}
\concept{multigraphs}
