% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_node.R
\name{add_node}
\alias{add_node}
\title{Generates the SQL to add a node to the database}
\usage{
add_node(data, identifier = NA)
}
\arguments{
\item{data}{Data to be added to the node in a list format}

\item{identifier}{The identifier for the node}
}
\value{
A SQL statement to add a node to a database
}
\description{
Generates the SQL to add a node to the database
}
\examples{
\dontrun{
library(simplegraphdb)
apple <- "apple_test.sqlite"
initialize(apple)

# Add nodes with data
atomic(apple, add_node(list(
  "name" = "Apple Computer Company",
  "type" = c("company", "start-up"),
  "founded" = "April 1, 1976"), 1))
atomic(apple, add_node(list(
  "name" = "Steve Wozniak",
  "type" = c("person", "engineer", "founder")), 2))
atomic(apple, add_node(list(
  "name" = "Steve Jobs",
  "type" = c("person", "designer", "founder")), 3))
atomic(apple, add_node(list(
  "name" = "Ronald Wayne",
  "type" = c("person", "administrator", "founder")), 4))
atomic(apple, add_node(list(
  "name" = "Mike Markkula",
  "type" = c("person", "investor")), 5))
}
}
