% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simrec-pkg.R, R/simrec.R
\docType{package}
\name{simrec}
\alias{simrec}
\alias{simrec-package}
\title{simrec}
\usage{
simrec(
  N,
  fu.min,
  fu.max,
  cens.prob = 0,
  dist.x = "binomial",
  par.x = 0,
  beta.x = 0,
  dist.z = "gamma",
  par.z = 0,
  dist.rec,
  par.rec,
  pfree = 0,
  dfree = 0
)
}
\arguments{
\item{N}{Number of individuals}

\item{fu.min}{Minimum length of follow-up.}

\item{fu.max}{Maximum length of follow-up. Individuals length of follow-up is
generated from a uniform distribution on
 \code{[fu.min, fu.max]}. If \code{fu.min=fu.max}, then all individuals have a common
 follow-up.}

\item{cens.prob}{Gives the probability of being censored due to loss to follow-up before
\code{fu.max}. For a random set of individuals defined by a B(N,\code{cens.prob})-distribution,
the time to censoring is generated from a uniform
distribution on \code{[0, fu.max]}. Default is \code{cens.prob=0}, i.e. no censoring
due to loss to follow-up.}

\item{dist.x}{Distribution of the covariate(s) \eqn{X}. If there is more than one covariate,
\code{dist.x} must be a vector of distributions with one entry for each covariate. Possible
values are \code{"binomial"} and \code{"normal"}, default is \code{dist.x="binomial"}.}

\item{par.x}{Parameters of the covariate distribution(s). For \code{"binomial", par.x} is
the probability for \eqn{x=1}. For \code{"normal"}, \code{par.x=c(}\eqn{\mu, \sigma}\code{)}
where \eqn{\mu} is the mean and \eqn{\sigma} is the standard deviation of a normal distribution.
If one of the covariates is defined to be normally distributed, \code{par.x} must be a list,
e.g. \code{ dist.x <- c("binomial", "normal")} and \code{par.x  <- list(0.5, c(1,2))}.
Default is \code{par.x=0}, i.e. \eqn{x=0} for all individuals.}

\item{beta.x}{Regression coefficient(s) for the covariate(s) \eqn{x}. If there is more than one
covariate, \code{beta.x} must be a vector of coefficients with one entry for each covariate.
\code{simrec} generates as many covariates as there are entries in \code{beta.x}. Default is
\code{beta.x=0}, corresponding to no effect of the covariate \eqn{x}.}

\item{dist.z}{Distribution of the frailty variable \eqn{Z} with \eqn{E(Z)=1} and
\eqn{Var(Z)=\theta}. Possible values are \code{"gamma"} for a Gamma distributed frailty
 and \code{"lognormal"} for a lognormal distributed frailty.
 Default is \code{dist.z="gamma"}.}

\item{par.z}{Parameter \eqn{\theta} for the frailty distribution: this parameter gives
the variance of the frailty variable \eqn{Z}.
Default is \code{par.z=0}, which causes \eqn{Z=1}, i.e. no frailty effect.}

\item{dist.rec}{Form of the baseline hazard function. Possible values are \code{"weibull"} or
\code{"gompertz"} or \code{"lognormal"} or \code{"step"}.}

\item{par.rec}{Parameters for the distribution of the event data.
If \code{dist.rec="weibull"} the  hazard function is \deqn{\lambda_0(t)=\lambda*\nu* t^{\nu - 1},}
where \eqn{\lambda>0} is the scale and \eqn{\nu>0} is the shape parameter. Then
\code{par.rec=c(}\eqn{\lambda, \nu}\code{)}. A special case
of this is the exponential distribution for \eqn{\nu=1}.\\
If \code{dist.rec="gompertz"}, the hazard function is \deqn{\lambda_0(t)=\lambda*exp(\alpha t),}
where \eqn{\lambda>0} is the scale and \eqn{\alpha\in(-\infty,+\infty)} is the shape parameter.
Then \code{par.rec=c(}\eqn{\lambda, \alpha}\code{)}.\\
If \code{dist.rec="lognormal"}, the hazard function is
\deqn{\lambda_0(t)=[(1/(\sigma t))*\phi((ln(t)-\mu)/\sigma)]/[\Phi((-ln(t)-\mu)/\sigma)],}
where \eqn{\phi} is the probability density function and \eqn{\Phi} is the cumulative
distribution function of the standard normal distribution, \eqn{\mu\in(-\infty,+\infty)} is a
location parameter and \eqn{\sigma>0} is a shape parameter. Then \code{par.rec=c(}\eqn{\mu,\sigma}\code{)}.
Please note, that specifying \code{dist.rec="lognormal"} together with some covariates does not
specify the usual lognormal model (with covariates specified as effects on the parameters of the
lognormal distribution resulting in non-proportional hazards), but only defines the baseline
hazard and incorporates covariate effects using the proportional hazard assumption.\\
If \code{dist.rec="step"} the hazard function is \deqn{\lambda_0(t)=a, t<=t_1, and \lambda_0(t)=b, t>t_1}.
Then \code{par.rec=c(}\eqn{a,b,t_1}\code{)}.}

\item{pfree}{Probability that after experiencing an event the individual is not at risk
for experiencing further events for a length of \code{dfree} time units.
Default is \code{pfree=0}.}

\item{dfree}{Length of the risk-free interval. Must be in the same time unit as \code{fu.max}.
Default is \code{dfree=0}, i.e. the individual is continously at risk for experiencing
events until end of follow-up.}
}
\value{
The output is a data.frame consisting of the columns:
   \item{id}{An integer number for identification of each individual}
   \item{x}{or \code{x.V1, x.V2, ...} - depending on the covariate matrix. Contains the
      randomly generated value of the covariate(s) \eqn{X} for each individual.}
   \item{z}{Contains the randomly generated value of the frailty variable \eqn{Z} for each individual.}
   \item{start}{The start of interval \code{[start, stop]}, when the individual
      starts to be at risk for a next event.}
   \item{stop}{The time of an event or censoring, i.e. the end of interval
   \code{[start, stop]}.}
   \item{status}{An indicator of whether an event occured at time \code{stop} (\code{status=1})
       or the individual is censored at time \code{stop} (\code{status=0}).}
   \item{fu}{Length of follow-up period \code{[0,fu]} for each individual.}
   For each individual there are as many lines as it experiences events,
   plus one line if being censored.
   The data format corresponds to the counting process format.
}
\description{
Simulation of recurrent event data for non-constant baseline hazard
(total-time model)

This function allows simulation of recurrent event data following the multiplicative
intensity model described in Andersen and Gill [1] with the baseline hazard being a
function of the total/calendar time. To induce between-subject-heterogeneity a random
effect covariate (frailty term) can be incorporated. Data for individual \eqn{i} are generated
according to the intensity process \deqn{Y_i(t) * \lambda_0(t)* Z_i *exp(\beta^t X_i),}
where \eqn{X_i} defines the covariate vector and \eqn{\beta} the regression coefficient vector.
\eqn{\lambda_0(t)} denotes the baseline hazard, being a function of the total/calendar
time \eqn{t}, and \eqn{Y_i(t)} the predictable process
that equals one as long as individual \eqn{i} is under observation and at risk for experiencing events.
\eqn{Z_i} denotes the frailty variable with \eqn{(Z_i)_i} iid with \eqn{E(Z_i)=1} and
\eqn{Var(Z_i)=\theta}. The parameter \eqn{\theta} describes the degree of
between-subject-heterogeneity. Data output is in the counting process format.
}
\details{
Simulation of recurrent event data for non-constant baseline hazard
in the total time model with risk-free intervalls and possibly a competing
event. The simrec package enables to cut the data to an interim data set,
and provides functionality to plot.

Data are simulated by extending the methods proposed by Bender et al [2]
to the multiplicative intensity model.
}
\examples{
### Example:
### A sample of 10 individuals

N <- 10

### with a binomially distributed covariate with a regression coefficient
### of beta=0.3, and a standard normally distributed covariate with a
### regression coefficient of beta=0.2,

dist.x <- c("binomial", "normal")
par.x <- list(0.5, c(0, 1))
beta.x <- c(0.3, 0.2)

### a gamma distributed frailty variable with variance 0.25

dist.z <- "gamma"
par.z <- 0.25

### and a Weibull-shaped baseline hazard with shape parameter lambda=1
### and scale parameter nu=2.

dist.rec <- "weibull"
par.rec <- c(1, 2)

### Subjects are to be followed for two years with 20\% of the subjects
### being censored according to a uniformly distributed censoring time
### within [0,2] (in years).

fu.min <- 2
fu.max <- 2
cens.prob <- 0.2

### After each event a subject is not at risk for experiencing further events
### for a period of 30 days with a probability of 50\%.

dfree <- 30 / 365
pfree <- 0.5

simdata <- simrec(
  N, fu.min, fu.max, cens.prob, dist.x, par.x, beta.x, dist.z, par.z,
  dist.rec, par.rec, pfree, dfree
)
# print(simdata)  # only run for small N!
}
\references{
\enumerate{
\item Andersen P, Gill R (1982): Cox's regression model for counting processes:
   a large sample study. The Annals of Statistics 10:1100-1120
\item Bender R, Augustin T, Blettner M (2005): Generating survival times to simulate Cox
  proportional hazards models. Statistics in Medicine 24:1713-1723
\item Jahn-Eimermacher A, Ingel K, Ozga AK, Preussler S, Binder H (2015): Simulating recurrent event data
  with hazard functions defined on a total time scale. BMC Medical Research Methodology 15:16
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/federicomarini/simrec}
}


simreccomp
}
\author{
Katharina Ingel, Stella Preussler, Antje Jahn-Eimermacher, Federico Marini

Maintainer: Antje Jahn-Eimermacher \email{jahna@uni-mainz.de}

Katharina Ingel, Stella Preussler, Antje Jahn-Eimermacher.
Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI),
University Medical Center of the Johannes Gutenberg-University Mainz, Germany
}
