% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{gammaGetShapeRate}
\alias{gammaGetShapeRate}
\title{Convert gamma mean and dispersion parameters to shape and rate parameters}
\usage{
gammaGetShapeRate(mean, dispersion)
}
\arguments{
\item{mean}{The mean of a gamma distribution}

\item{dispersion}{The dispersion parameter of a gamma distribution}
}
\value{
A list that includes the shape and rate parameters of the gamma distribution
}
\description{
Convert gamma mean and dispersion parameters to shape and rate parameters
}
\details{
In simstudy, users specify the gamma distribution as a function of two parameters - a mean
and dispersion. In this case, the variance of the specified distribution is (mean^2)*dispersion.
The base R function rgamma uses the shape and rate parameters to specify the gamma distribution.
This function converts the mean and dispersion into the shape and rate.
}
\examples{
set.seed(12345)
mean <- 5
dispersion <- 1.5
rs <- gammaGetShapeRate(mean, dispersion)
c(rs$shape, rs$rate)
vec <- rgamma(1000, shape = rs$shape, rate = rs$rate)
(estMoments <- c(mean(vec), var(vec)))
(theoryMoments <- c(mean, mean^2 * dispersion))
(theoryMoments <- c(rs$shape / rs$rate, rs$shape / rs$rate^2))
}
\concept{utility}
