% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{onekmeans}
\alias{onekmeans}
\title{One-run of the K-means clustering technique}
\usage{
onekmeans(Y_i_qr, G, U_i_g = NULL, seed = NULL)
}
\arguments{
\item{Y_i_qr}{Input data to group/cluster.}

\item{G}{Number of clusters to find.}

\item{U_i_g}{Initial membership matrix for the I objects.}

\item{seed}{Seed for random values generation.}
}
\value{
updated membership matrix U_i_g.
}
\description{
Initializes centroids based on a given membership function matrix or randomly.
Iterate once over the input data to update the membership function matrix
assigning objects to the closest centroids.
}
\examples{
X_i_jk = generate_dataset(seed=0)$X_i_jk
onekmeans(X_i_jk, G=5)

}
\references{
\insertRef{k_meansMethods}{simuclustfactor}
}
