% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_rmd.R
\name{pretty_rmd}
\alias{pretty_rmd}
\title{Attach namespacing to Rmarkdown chunks}
\usage{
pretty_rmd(
  input,
  output = tempfile(fileext = ".Rmd"),
  open_output = TRUE,
  create_library = TRUE,
  chunks = NULL,
  ...
)
}
\arguments{
\item{input}{character, path to input Rmd file}

\item{output}{character, path to output Rmd file, Default: NULL}

\item{open_output}{boolean, open the output on.exit, Default: TRUE}

\item{create_library}{boolean, create library chunk, Default: TRUE}

\item{chunks}{numeric, indicies of chunks to run on, Default: NULL}

\item{\dots}{arguments to pass to pretty_namespace}
}
\value{
character
}
\description{
Apply pretty_namespace to Rmarkdown document
}
\details{
If output is NULL then the returned lines are printed to console.
If chunks is NULL then all the chunks are used.
}
\examples{
\dontrun{
  if(interactive()){
    pretty_rmd(input = system.file('example.Rmd',package = 'sinew'))
  }
}
}
\seealso{
\link[=pretty_namespace]{pretty_namespace}
}
\author{
Jonathan Sidi
}
\concept{namespace}
