% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_qacademico.R
\name{read_qacademico}
\alias{read_qacademico}
\title{Read Qacademico files}
\usage{
read_qacademico(path = "", start = NULL)
}
\arguments{
\item{path}{The Qacademico file's path.}

\item{start}{A character with the date to start the comparison. The default is the minimum
value found in the data. The date has to be in this format: "yyyy.semester".
Ex.: "2019.1" or "2019.2".}
}
\value{
A data frame.
}
\description{
This function support two kinds of schemas: from the api and the website. See Details
if you need help to download the Qacademico data.
}
\details{
To download the student's data, go to your proper account on Qacademico and
follow:
\itemize{
\item "Relatorio de Alunos" -> "Listagem de Alunos" (choose year and period)
\item Click on "visualizar"
\item Using F10 shortcut and save in .csv format
\item Rename the including year and period (example2020_1.csv)
}

Be sure that your data has the variables: "Matricula", "Nome", "Situacao Matricula",
"Curso", "Cpf", "Instituicao", "Per. Letivo Inicial" and "Cota".
}
\examples{
 
# this dataset is not a real one. It is just for test purpose.
qacademico <- read_qacademico(system.file("extdata/examples/qacademico",
                                          package = "sistec"))

qacademico
}
