% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{as_policy_arn}
\alias{as_policy_arn}
\title{Convert a policy name to a policy ARN}
\usage{
as_policy_arn(name, local = FALSE, path = NULL)
}
\arguments{
\item{name}{(character) a policy name or arn}

\item{local}{(logical) if \code{TRUE} use your AWS account for your own
managed policies. If \code{FALSE}, AWS managed policies}

\item{path}{(character) if not \code{NULL}, we add the path into the ARN
before the \code{name} value}
}
\value{
a policy ARN (character)
}
\description{
This function simply constructs a string. It only makes an HTTP request
if \code{local=TRUE} and environment variable \code{AWS_PROFILE} != "localstack"
}
\examples{
as_policy_arn("ReadOnlyAccess")
as_policy_arn("arn:aws:iam::aws:policy/ReadOnlyAccess")
as_policy_arn("AmazonRDSDataFullAccess")

# path = Job function
as_policy_arn("Billing", path = "job-function")

# path = Service role
as_policy_arn("AWSCostAndUsageReportAutomationPolicy",
  path = "service-role"
)

\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
as_policy_arn("MyTestPolicy", local = TRUE)
# returns an arn - and if given an arn returns self
as_policy_arn("MyTestPolicy", local = TRUE) \%>\%
  as_policy_arn()
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
