% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-rds.R
\name{aws_db_rds_create}
\alias{aws_db_rds_create}
\title{Create an RDS cluster}
\usage{
aws_db_rds_create(
  id,
  class,
  user = NULL,
  pwd = NULL,
  dbname = "dev",
  engine = "mariadb",
  storage = 20,
  storage_encrypted = TRUE,
  security_group_ids = NULL,
  wait = TRUE,
  verbose = TRUE,
  aws_secrets = TRUE,
  iam_database_auth = FALSE,
  ...
)
}
\arguments{
\item{id}{(character) required. instance identifier. The identifier for
this DB instance. This parameter is stored as a lowercase string.
Constraints: must contain from 1 to 63 letters, numbers, or hyphens; first
character must be a letter; can't end with a hyphen or contain two
consecutive hyphens. required.}

\item{class}{(character) required. The compute and memory capacity of the
DB instance, for example \code{db.m5.large}.}

\item{user}{(character) User name associated with the admin user account for
the cluster that is being created. If \code{NULL}, we generate a random user
name, see \code{\link[=random_user]{random_user()}}}

\item{pwd}{(character) Password associated with the admin user account for
the cluster that is being created. If \code{NULL}, we generate a random password
with \code{\link[=aws_secrets_pwd]{aws_secrets_pwd()}} (which uses the AWS Secrets Manager service)}

\item{dbname}{(character) The name of the first database to be created when
the cluster is created. default: "dev". additional databases can be created
within the cluster}

\item{engine}{(character) The engine to use. default: "mariadb". required.
one of: mariadb, mysql, or postgres}

\item{storage}{(character) The amount of storage in gibibytes (GiB) to
allocate for the DB instance. default: 20}

\item{storage_encrypted}{(logical) Whether the DB instance is encrypted.
default: \code{TRUE}}

\item{security_group_ids}{(character) VPC security group identifiers; one
or more. If none are supplied, you should go into your AWS Redshift
dashboard and add the appropriate VPC security group.}

\item{wait}{(logical) wait for cluster to initialize? default: \code{TRUE}. If
you don't wait (\code{FALSE}) then there's many operations you can not do
until the cluster is available. If \code{wait=FALSE} use
\code{aws_db_instance_status()} to check on the cluster status.}

\item{verbose}{(logical) verbose informational output? default: \code{TRUE}}

\item{aws_secrets}{(logical) should we manage your database credentials
in AWS Secrets Manager? default: \code{TRUE}}

\item{iam_database_auth}{(logical) Use IAM database authentication?
default: \code{FALSE}}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/rds_create_db_instance/}{create_db_instance}}
}
\value{
returns \code{NULL}, this function called for the side effect of
creating an RDS instance
}
\description{
Create an RDS cluster
}
\details{
See above link to \code{create_db_instance} docs for details on
requirements for each parameter

Note that even though you can use any option for \code{engine} in this function,
we may not provide the ability to connect to the chosen data source
in this package.
}
\section{Waiting}{

Note that with \code{wait = TRUE} this function waits for the instance to be
available for returning. That wait can be around 5 - 7 minutes. You can
instead set \code{wait = FALSE} and then check on the status of the instance
yourself in the AWS dashboard.
}

\seealso{
Other database: 
\code{\link{aws_db_cluster_status}()},
\code{\link{aws_db_instance_status}()},
\code{\link{aws_db_rds_con}()},
\code{\link{aws_db_rds_list}()},
\code{\link{aws_db_redshift_con}()},
\code{\link{aws_db_redshift_create}()}
}
\concept{database}
