% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{resource_rds}
\alias{resource_rds}
\title{Create a resource string for a policy statement for RDS}
\usage{
resource_rds(
  user,
  resource_id,
  region = Sys.getenv("AWS_REGION"),
  account = account_id()
)
}
\arguments{
\item{user}{(character) a user name that has an IAM account. length>=1.
required}

\item{resource_id}{(character) the identifier for the DB instance.
length==1. required}

\item{region}{(character) the AWS Region for the DB instance. length==1}

\item{account}{(character) the AWS account number for the DB instance.
length==1. The user must be in the same account as the account for the
DB instance. by default calls \code{\link[=account_id]{account_id()}}}
}
\value{
a resource ARN (scalar, character)
}
\description{
Create a resource string for a policy statement for RDS
}
