% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_matrix.R
\name{as_coord_matrix}
\alias{as_coord_matrix}
\alias{coord_matrix}
\alias{as_coord_matrix.default}
\alias{as_coord_matrix.numeric}
\alias{as_coord_matrix.sf}
\alias{as_coord_matrix.sfc_POINT}
\alias{as_coord_matrix.matrix}
\alias{as_coord_matrix.data.frame}
\title{Coerce an R object to a matrix of coordinates}
\usage{
as_coord_matrix(x, ...)

\method{as_coord_matrix}{default}(x, ...)

\method{as_coord_matrix}{numeric}(x, ...)

\method{as_coord_matrix}{sf}(x, ...)

\method{as_coord_matrix}{sfc_POINT}(x, ...)

\method{as_coord_matrix}{matrix}(x, ..., loncol = guess_loncol(x), latcol = guess_latcol(x))

\method{as_coord_matrix}{data.frame}(x, ..., loncol = guess_loncol(x), latcol = guess_latcol(x))
}
\arguments{
\item{x}{any of the following:
\itemize{
\item a \code{matrix}: Either a matrix with named \code{longitude} and \code{latitude} columns
or an unnamed two column matrix containing longitude and latitude
(in that order)
\item a \code{data.frame} with named \code{longitude} and \code{latitude} columns
\item an \link[sf:sfc]{sf::sfc_POINT} object
\item a named or unnamed \code{numeric} vector of length 2 containing a single
longitude-latitude coordinate pair
\item a \code{character} scalar path or URL to a shapefile or zipped shapefile
}}

\item{...}{passed on to methods}

\item{loncol, latcol}{\code{character} scalars. Names of the columns of
\code{x} containing longitude and latitude. The default trying guessing the
columns.}
}
\value{
\code{as_coord_matrix()} returns a \code{coord_matrix} object: A numeric
\code{matrix} with the columns \code{"lon"}and \code{"lat"} (in that order)
}
\description{
A \code{coord_matrix} is a \code{matrix} with two columns named \code{"lon"} and \code{"lat"} to
represent spatial point data. They are used as an intermediary when
converting some \R objects to \code{\link[sf:sf]{sf::sf()}} objects.

\code{as_coord_matrix()} can smartly convert a range of \R objects to
\code{coord_matrix}. If you are a package developer and want to add support
for smartmap to your package without having to depend on the heavy \pkg{sf}
package, it is enough to provide an \code{as_coord_matrix()} method.
}
\seealso{
\url{https://stackoverflow.com/questions/7309121/preferred-order-of-writing-latitude-longitude-tuples}
}
