% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gedist.R
\name{gedist}
\alias{gedist}
\alias{eucdist}
\alias{gcdist}
\title{Compute distance for geographic coordinates}
\usage{
gedist(x, y = NULL, longlat = FALSE)

eucdist(x, y = NULL)

gcdist(x, y = NULL)
}
\arguments{
\item{x}{A two-dimensional matrix of coordinates.}

\item{y}{A two-dimensional matrix of coordinates.}

\item{longlat}{A logical value indicating whether
Euclidean distance (\code{longlat = FALSE}) or great
circle distance (\code{longlat = FALSE}) should be
computed. The default is \code{longlat = FALSE}.}
}
\value{
A matrix of distances
}
\description{
\code{gedist} computes the distance between the
coordinates in \code{x} and \code{y}. If \code{y} isn't
supplied, then the distances are computed between the
coordinates in \code{x} alone. Otherwise, the pairwise
distances between the points in \code{x} and \code{y} are
computed. If \code{longlat = TRUE}, then the great circle
distance is computed. \code{eucdist} is a simplified
version of \code{gedist} that computes Euclidean
distances alone while \code{gcdist} is a simplified
version of \code{gedist} that computes great circle
distance alone.
}
\details{
The algorithm used when \code{longlat = TRUE} is a C++
port of the C code written by Roger Bivand for the
\code{spDists} function in the \code{sp} package, which
appears to be based on a special case of the Vincenty
formula with a slight correction based on the WGS84
flattening constant. See
\url{https://en.wikipedia.org/wiki/Great-circle_distance}.
}
\examples{
coords = matrix(runif(10), ncol = 2)
# euclidean distance
d = gedist(coords)
all.equal(d, as.matrix(dist(coords)),
          check.attributes = FALSE)
all.equal(gedist(coords), eucdist(coords))

# great circle distance
all.equal(gedist(coords, longlat = TRUE),
          gcdist(coords))
}
