% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_posterior_no_infections.R
\name{calculate_posterior_no_infections}
\alias{calculate_posterior_no_infections}
\title{Negative analysis probability}
\usage{
calculate_posterior_no_infections(
  negative_persons,
  infected_persons,
  event,
  test_infos,
  test_types,
  subgroup_size,
  distribution = NULL,
  info
)
}
\arguments{
\item{negative_persons}{Number of people without the infectious persons.}

\item{infected_persons}{Number of infectious persons.}

\item{event}{Characters, the name of the event, currently: "school" or "day_care_center".}

\item{test_infos}{Matrix with testing information; each row gives the number of
tests (1. column) and each test date (following columns) for each test group}

\item{test_types}{Matrix with test day (columns) of each group (rows) and the informations about test types.}

\item{subgroup_size}{Array with the number of persons per test group.}

\item{distribution}{Vector, this is a placeholder}

\item{info}{Dataframe, this is a placeholder}
}
\value{
The probability p.
}
\description{
Calculates the probability that nobody is infected given the negative tests.
}
\details{
The probability is based on Bayes' theorem.
}
\examples{
test_infos <- matrix(nrow = 2, ncol = 3)
test_infos[1,] <- c(1, 2, NA)
test_infos[2,] <- c(2, 4, 6)

test_types <- matrix(nrow = 2, ncol = 2)
test_types[1,] <- c("PCR", NA)
test_types[2,] <- c("PCR", "Antigen")

calculate_posterior_no_infections(negative_persons = 23,
                                  infected_persons = 2,
                                  event = "school",
                                  test_infos = test_infos,
                                  test_types = test_types,
                                  subgroup_size = c(3, 5))

}
\seealso{
\code{\link{calculate_prior_infections}},
\code{\link{generate_data_extended}}, \code{\link{get_test_sensitivities}}
and \code{\link{calculate_likelihood_negative_tests}}.
}
