% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{crossvalidation}
\alias{crossvalidation}
\title{Perform cross validation to select the regularization parameter.}
\usage{
crossvalidation(auxfun, X, y, param, K = 10)
}
\arguments{
\item{auxfun}{A complete fitting function which takes as arguments a data matrix \eqn{X}, a response vector \eqn{y}, and some parameter \eqn{p} (to be tuned), and returns the estimator (\eqn{betavector}) (minimizer) of the regression operator under investigation.}

\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{param}{A vector of regularization parameters which are to be evaluated via cross validation.}

\item{K}{The number of folds for cross validation (should divide the number of rows of \eqn{X}). The default is \eqn{10}.}
}
\value{
A vector of average errors over all folds. The entries in the returned vector correspond to the entries in the vector \eqn{param} in the same order.
}
\description{
Perform cross validation to select the regularization parameter.
}
\examples{
library(smoothedLasso)
n <- 1000
p <- 100
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
auxfun <- function(X,y,lambda) {
		temp <- standardLasso(X,y,lambda)
	obj <- function(z) objFunction(z,temp$u,temp$v,temp$w)
		objgrad <- function(z) objFunctionGradient(z,temp$w,temp$du,temp$dv,temp$dw)
	return(minimizeFunction(p,obj,objgrad))
}
lambdaVector <- seq(0,1,by=0.1)
print(crossvalidation(auxfun,X,y,lambdaVector,10))

}
\references{
Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.

Tibshirani, R. (2013). Model selection and validation 1: Cross-validation. https://www.stat.cmu.edu/~ryantibs/datamining/lectures/18-val1.pdf
}
