% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_put_together.R
\name{sm_put_together}
\alias{sm_put_together}
\title{Combine Multiple Plots into a Single Composite Figure}
\usage{
sm_put_together(
  all_plots,
  title = NULL,
  xlabel = NULL,
  ylabel = NULL,
  legend = NULL,
  ncol = NULL,
  nrow = NULL,
  xlabel2 = NULL,
  ylabel2 = NULL,
  tickRatio = NULL,
  panel_scale = 0.9,
  wRatio = NULL,
  hRatio = NULL,
  hmargin = 0,
  wmargin = 0,
  remove_ticks = "some",
  wRatio2 = NULL,
  hRatio2 = NULL,
  labelRatio = 1
)
}
\arguments{
\item{all_plots}{A list of ggplot objects to be combined. Each plot should
ideally include tick labels on both x and y axes to allow the function to
optimize the layout effectively.}

\item{title}{A ggplot layer or character string specifying the title of the
combined figure. If supplied as a string, the function dynamically adjusts
its size and placement. Optional.}

\item{xlabel}{A ggplot layer or character string specifying the label for the
x-axis of the combined figure. Optional.}

\item{ylabel}{A ggplot layer or character string specifying the label for the
y-axis of the combined figure. Optional.}

\item{legend}{A ggplot legend layer to be added to the combined figure. Optional.}

\item{ncol}{Number of columns in the combined figure grid. If not supplied,
the function determines this based on the number of plots.}

\item{nrow}{Number of rows in the combined figure grid. If not supplied,
the function determines this based on the number of plots.}

\item{xlabel2}{A secondary x-axis label layer or character string. Optional.}

\item{ylabel2}{A secondary y-axis label layer or character string. Optional.}

\item{tickRatio}{A scaling factor for tick label size. By default, this is
adjusted dynamically based on the number of rows and columns in the grid.
Larger values increase tick label size. Optional.}

\item{panel_scale}{A numeric value between 0 and 1 that scales the individual
panels to reduce empty space within and around each panel. Default is `0.9`.}

\item{wRatio}{A scaling factor for the width of the first column relative to
other columns. By default, this is computed based on the input plots. Users
can override it with a numeric value. Optional.}

\item{hRatio}{A scaling factor for the height of the last row relative to other
rows. By default, this is computed based on the input plots. Users can override
it with a numeric value. Optional.}

\item{hmargin}{Vertical margin between subplots. Positive values increase the
spacing, while negative values reduce it. Default is `0`.}

\item{wmargin}{Horizontal margin between subplots. Positive values increase the
spacing, while negative values reduce it. Default is `0`.}

\item{remove_ticks}{Specifies whether to remove ticks from the inner panels:
`"some"` (default) removes ticks only from inner plots, `"all"` removes ticks
from all plots, and `"none"` keeps all ticks.}

\item{wRatio2}{A scaling factor for the width of the last column relative to
other columns. By default, this is computed based on the input plots. Optional.}

\item{hRatio2}{A scaling factor for the height of the first row relative to
other rows. By default, this is computed based on the input plots. Optional.}

\item{labelRatio}{A scaling factor for the text size of titles, axis labels,
and secondary labels when provided as character strings. Default is `1`.
Larger values increase text size proportionally.}
}
\value{
A composite ggplot object combining the input plots into a grid layout.
}
\description{
`sm_put_together` combines multiple ggplot objects into a single composite figure.
The function optimizes the layout by considering the presence of tick labels and
axis labels in the input plots, ensuring a clean and well-aligned output.
}
\details{
Users can supply custom titles and axis labels either as ggplot layers created
with `sm_common_xlabel()`, `sm_common_ylabel()`, and `sm_common_title()` or as
character strings directly. The function attempts to adjust the size and placement
of titles and labels dynamically based on the input plots.

While the `all_plots` argument is required, all other arguments are optional,
and defaults are provided for most parameters.
}
\examples{
library(smplot2)
library(ggplot2)

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
geom_point(shape = 21, fill = '#0f993d', color = 'white',
          size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
  sm_hvgrid() -> p2

title <- sm_common_title('My title')
xlabel <- sm_common_xlabel('My x-axis')
ylabel <- sm_common_ylabel('My y-axis')

sm_put_together(list(p1,p2), title=title, xlabel=xlabel,
                ylabel=ylabel, ncol=2,nrow=1)

sm_put_together(list(p1,p2), title='My title', xlabel='My x-axis',
                ylabel='My y-axis', labelRatio = 1.1, ncol=2,nrow=1)

}
