% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_associations.R
\name{gtable_ld_associations_gdata}
\alias{gtable_ld_associations_gdata}
\title{Gtable of linkage disequilibrium and associations using a GenotypeData object}
\usage{
gtable_ld_associations_gdata(
  df_assocs,
  gdata,
  pvalue_colname = "pvalues",
  labels_colname = "probe_id",
  diamonds = nrow(df_assocs) <= 40,
  window = 15,
  ...
)
}
\arguments{
\item{df_assocs}{SNP annotation data frame with columns chromosome,
position, and as specified by parameters pvalue_colname
and optionally labels_colname.}

\item{gdata}{GenotypeData object, as returned by
load_gds_as_genotype_data}

\item{pvalue_colname}{Column name of df_snp with association values}

\item{labels_colname}{Optional column name of df_snp with labels.
Set NULL to remove labels.}

\item{diamonds}{Should the values be displayed as diamonds or points ?
Default is TRUE for up to 40 SNPs.}

\item{window}{Window size for snprelate_ld.
Forced to the total number of SNPs if diamonds is FALSE}

\item{...}{Passed to gtable_ld_associations}
}
\value{
gtable
}
\description{
Compute linkage disequilibrium using snprelate_ld on the set of SNPs in the
associations data frame and call gtable_ld_associations.
Creates a gtable of a linkage disequilibrium, chromosomic positions, and
association scores ggplots.
}
\examples{
library(snplinkage)
gds_path <- save_hgdp_as_gds()
gdata <- load_gds_as_genotype_data(gds_path)
qc <- snprelate_qc(gdata, tagsnp = .99)

snp_idxs_mhc <- select_region_idxs(qc$gdata,
  chromosome = 6, position_min = 29e6, position_max = 33e6)
df_assocs <- chisq_pvalues_gdata(qc$gdata, snp_idxs_mhc)

df_top_aim <- subset(df_assocs, rank(-pvalues, ties.method = 'first') <= 20)

#qc$gdata <- gdata_add_gene_annots(qc$gdata, rownames(df_top_aim))
qc$gdata <- gdata_add_gene_annots_aim_example(qc$gdata, rownames(df_top_aim))

plt <- gtable_ld_associations_gdata(df_top_aim, qc$gdata,
  labels_colname = 'gene')

}
