% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendMissingCoalitions.R
\name{appendMissingCoalitions}
\alias{appendMissingCoalitions}
\title{Append missing coalitions}
\usage{
appendMissingCoalitions(powerRelation, includeEmptySet = TRUE)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{includeEmptySet}{If \code{TRUE}, include the empty set in the last equivalence class if it is missing from the power relation.}
}
\value{
\code{\link{PowerRelation}} object containing the following values:
\itemize{
\item \verb{$elements}: vector of elements
\item \verb{$eqs}: equivalence classes. Nested list of lists, each containing vectors representing groups of elements in the same equivalence class
\item \verb{$coalitionLookup}: \verb{function(v)} taking a coalition vector \code{v} and returning the equivalence class it belongs to. See \code{\link[=coalitionLookup]{coalitionLookup()}} for more.
\item \verb{$elementLookup}: \verb{function(e)} taking an element \code{e} and returning a list of 2-sized tuples. See \code{\link[=elementLookup]{elementLookup()}} for more.
}
}
\description{
Append an equivalence class to a power relation with all coalitions of elements that do not appear in the power relation.
}
\details{
For a given set of elements \eqn{N = \lbrace 1, ..., n \rbrace}{N = \{1, ..., n\}}, a \code{\link{PowerRelation}} object describes a total preorder
of its subsets, or coalitions, \eqn{\mathcal{P} \subseteq 2^N}{P subseteq 2^N}, where \eqn{2^N}{2^N} is the superset of elements.

If \eqn{\mathcal{P} \neq 2^N}{P != 2^N}, that means that there are some coalitions \eqn{S \in 2^N, S \notin \mathcal{P}}{S in 2^N, S not in P},
such that we cannot compare \eqn{S \succsim T}{S >= T} or \eqn{T \succsim S}{T >= S} for every \eqn{T \in \mathcal{P}}{T in P}.

This may be caused by \eqn{2^N}{2^N} having too many coalitions to consider.
In certain cases, it may be more interesting to only consider the top ranking coalitions and "shoving" all remaining coalitions into the back.

For this use-case, \code{appendMissingCoalitions()} takes the set \eqn{2^N \setminus \mathcal{P}}{2^N - P}
and attaches it in form of an equivalence class to the back of the power relation.

I.e., take as an example \eqn{12 \succ 13 \succ (1 \sim 2)}{12 > 13 > (1 ~ 2)}. Here, we have

\deqn{
\begin{aligned}
2^N &= \lbrace 123, 12, 13, 23, 1, 2, 3, \emptyset \rbrace\\
\mathcal{P} &= \lbrace 12, 13, 1, 2 \rbrace\\
2^N \setminus \mathcal{P} &= \lbrace 123, 23, 3, \emptyset \rbrace .
\end{aligned}
}{
2^N = \{ 123, 12, 13, 23, 1, 2, 3, \{\} \}\\
P = \{12, 13, 1, 2\}\\
2^N - P = \{123, 23, 3, \{\}\}
}

Adding the missing coalitions to the power relation then gives us \eqn{12 \succ 13 \succ (1 \sim 2) \succ (123 \sim 23 \sim 3 \sim \emptyset)}{12 > 13 > (1 ~ 2) > (123 ~ 23 ~ 3 ~ \{\})}.
}
\examples{
pr <- as.PowerRelation(list(c(1,2), 3))
# 12 > 3

appendMissingCoalitions(pr)
# 12 > 3 > (123 ~ 13 ~ 23 ~ 1 ~ 2 ~ {})

appendMissingCoalitions(pr, includeEmptySet = FALSE)
# 12 > 3 > (123 ~ 13 ~ 23 ~ 1 ~ 2)

}
\seealso{
Other helper functions for transforming power relations: 
\code{\link{makePowerRelationMonotonic}()}
}
\concept{helper functions for transforming power relations}
