% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_changes.R
\name{db_changes}
\alias{db_changes}
\title{List changes to a database.}
\usage{
db_changes(
  cushion,
  dbname,
  descending = NULL,
  startkey = NULL,
  endkey = NULL,
  since = NULL,
  limit = NULL,
  include_docs = NULL,
  feed = "normal",
  heartbeat = NULL,
  filter = NULL,
  as = "list",
  ...
)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{Database name. (character)}

\item{descending}{Return in descending order? (logical)}

\item{startkey}{Document ID to start at. (character)}

\item{endkey}{Document ID to end at. (character)}

\item{since}{Start the results from the change immediately after the given
sequence number.}

\item{limit}{Number document IDs to return. (numeric)}

\item{include_docs}{(character) If "true", returns docs themselves, in
addition to IDs}

\item{feed}{Select the type of feed. One of normal, longpoll, or continuous.
See description. (character)}

\item{heartbeat}{Period in milliseconds after which an empty line is sent in
the results. Only applicable for longpoll or continuous feeds. Overrides any
timeout to keep the feed alive indefinitely. (numeric (milliseconds))}

\item{filter}{Reference a filter function from a design document to
selectively get updates.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
Either a list of json (depending on \code{as} parameter), with
keys:
\itemize{
\item results - Changes made to a database, length 0 if no changes.
Each of these has:
\itemize{
\item changes - List of document`s leafs with single field rev
\item id - Document ID
\item seq - Update sequence
}
\item last_seq - Last change update sequence
\item pending - Count of remaining items in the feed
}
}
\description{
Of course it doesn't make much sense to use certain options in
_changes. For example, using feed=longpoll or continuous doesn't make much
sense within R itself.
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("leoalion" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="leoalion"))
}
db_create(x, dbname='leoalion')

# no changes
res <- db_changes(x, dbname="leoalion")
res$results

# create a document
doc1 <- '{"name": "drink", "type": "water", "score": 5}'
doc_create(x, dbname="leoalion", doc1, docid="awater")

# now there's changes
res <- db_changes(x, dbname="leoalion")
res$results

# as JSON
db_changes(x, dbname="leoalion", as='json')
}
}
