% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uuids.r
\name{uuids}
\alias{uuids}
\title{Get uuids.}
\usage{
uuids(cushion, count = 1, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{count}{(numeric) Number of uuids to return. Default: 1}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Get uuids.
}
\examples{
\dontrun{
# Create a CouchDB connection client
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

uuids(x)
uuids(x, as = 'json')
}
}
