% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_pmgroupname.R
\name{get_SDA_pmgroupname}
\alias{get_SDA_pmgroupname}
\title{Get map unit parent material group information from Soil Data Access}
\usage{
get_SDA_pmgroupname(
  areasymbols = NULL,
  mukeys = NULL,
  WHERE = NULL,
  method = "DOMINANT COMPONENT",
  simplify = TRUE,
  include_minors = TRUE,
  miscellaneous_areas = FALSE,
  query_string = FALSE,
  dsn = NULL
)
}
\arguments{
\item{areasymbols}{\emph{character}. Vector of soil survey area symbols}

\item{mukeys}{\emph{integer}. Vector of map unit keys}

\item{WHERE}{\emph{character}. SQL WHERE clause specified in terms of fields in \code{legend}, \code{mapunit}, \code{component}, or \code{copmgrp} tables, used in lieu of \code{mukeys} or \code{areasymbols}}

\item{method}{\emph{character}. One of: \code{"Dominant Component"}, \code{"Dominant Condition"}, \code{"None"}}

\item{simplify}{\emph{logical}. Group into generalized parent material groups? Default \code{TRUE}}

\item{include_minors}{logical. Include minor components? Default: \code{TRUE}.}

\item{miscellaneous_areas}{\emph{logical}. Include miscellaneous areas (non-soil components) in results? Default: \code{FALSE}.}

\item{query_string}{Default: \code{FALSE}; if \code{TRUE} return a character string containing query that would be sent to SDA via \code{SDA_query}}

\item{dsn}{Path to local SQLite database or a DBIConnection object. If \code{NULL} (default) use Soil Data Access API via \code{SDA_query()}.}
}
\value{
a data.frame
}
\description{
Get map unit parent material group information from Soil Data Access
}
\details{
Default \code{method} is \code{"Dominant Component"} to get the dominant component (highest percentage). Use \code{"Dominant Condition"} or dominant parent material condition (similar conditions aggregated across components). Use \code{"None"} for no aggregation (one record per component).
}
\author{
Jason Nemecek, Chad Ferguson, Andrew Brown
}
