% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soiltexture.R
\name{TT.text.transf.X}
\alias{TT.text.transf.X}
\title{Log-linear transformation of a soil texture data table between 2 particle
size systems (X classes).}
\usage{
TT.text.transf.X(
  tri.data,
  base.ps.lim,
  dat.ps.lim,
  text.sum = NULL,
  text.tol = NULL,
  tri.sum.tst = NULL,
  tri.pos.tst = NULL
)
}
\arguments{
\item{tri.data}{See \code{\link[soiltexture]{TT.plot}}}

\item{base.ps.lim}{Vector of numeric value. Particle size limits of the system tri.data should be converted into.}

\item{dat.ps.lim}{Vector of numeric value. Particle size limits of tri.data.}

\item{text.sum}{See \code{\link[soiltexture]{TT.plot}}}

\item{text.tol}{See See \code{\link[soiltexture]{TT.plot}}}

\item{tri.sum.tst}{See \code{\link[soiltexture]{TT.plot}}}

\item{tri.pos.tst}{See \code{\link[soiltexture]{TT.plot}}}
}
\description{
Log-linear transformation of a soil texture data table ('tri.data') from one
particle size system ('dat.css.ps.lim') into another ('base.css.ps.lim'). No
limit in the number of partile size classes in the inputed and outputed
texture tables. See TT.text.transf for transformation involving only 3
particle classes. 'tri.data' can only contain texture data.
}
\author{
Julien Moeys [aut, cre], Wei Shangguan [ctb], Rainer Petzold [ctb],
Budiman Minasny [ctb], Bogdan Rosca [ctb], Nic Jelinski [ctb], Wiktor
Zelazny [ctb], Rodolfo Marcondes Silva Souza [ctb], Jose Lucas Safanelli
[ctb], Alexandre ten Caten [ctb]
}
