% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sotkanet_cite.R
\name{sotkanet_cite}
\alias{sotkanet_cite}
\title{Crate a Data Bibliography}
\usage{
sotkanet_cite(id, lang = "fi", format = "Biblatex")
}
\arguments{
\item{id}{Indicator id.}

\item{lang}{Language for the citation. Options are English (en), Finnish (fi) and Swedish (sv).}

\item{format}{Default is "Biblatex", alternatives are "bibentry" or "Bibtex".}
}
\value{
a Biblatex, bibentry or Bibtex object.
}
\description{
Crates a bibliography from selected Sotkanet data file.
}
\examples{
\dontrun{
SotkanetCite(10013, lang = "en", format = "Biblatex")
SotkanetCite(10012, lang = "fi", format = "Biblatex")
SotkanetCIte(10011, lang = "sv", format = "Biblatex")
SotkanetCite(10013, lang = "en", format = "bibentry")
SotkanetCite(10013, lang = "en", format = "Bibtex")
}
}
\references{
See citation("sotkanet")
}
\seealso{
[utils::bibentry()] [RefManageR::toBiblatex()]
}
