% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesMvLMconjugate.R
\name{bayesMvLMconjugate}
\alias{bayesMvLMconjugate}
\title{Gibbs sampler for Conjugate Bayesian Multivariate Linear Models}
\usage{
bayesMvLMconjugate(Y, X, mu_B, V_B, nu, Psi, n_iter = 1000, burn_in = 500)
}
\arguments{
\item{Y}{\link{matrix} \eqn{n \times q} of response variables}

\item{X}{\link{matrix} \eqn{n \times p} of predictors}

\item{mu_B}{\link{matrix} \eqn{p \times q} prior mean for \eqn{\beta}}

\item{V_B}{\link{matrix} \eqn{p \times p} prior row covariance for \eqn{\beta}}

\item{nu}{\link{double} prior parameter for \eqn{\Sigma}}

\item{Psi}{\link{matrix} prior parameter for \eqn{\Sigma}}

\item{n_iter}{\link{integer} iteration number for Gibbs sampler}

\item{burn_in}{\link{integer} number of burn-in iteration}
}
\value{
B_samples \link{array} of posterior sample for \eqn{\beta}

Sigma_samples \link{array} of posterior samples for \eqn{\Sigma}
}
\description{
Gibbs sampler for Conjugate Bayesian Multivariate Linear Models
}
\examples{
## Generate data
n <- 100
p <- 3
q <- 2
Y <- matrix(rnorm(n*q), nrow = n, ncol = q)
X <- matrix(rnorm(n*p), nrow = n, ncol = p)

## Prior parameters
mu_B <- matrix(0, p, q)
V_B <- diag(10, p)
nu <- 3
Psi <- diag(q)

## Samples from posteriors
n_iter <- 1000
burn_in <- 500
set.seed(1234)
samples <- spBPS::bayesMvLMconjugate(Y, X, mu_B, V_B, nu, Psi, n_iter, burn_in)

}
