% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.distance.R
\name{topo.distance}
\alias{topo.distance}
\title{Topographic distance}
\usage{
topo.distance(x, r, echo = FALSE)
}
\arguments{
\item{x}{sf LINESTRING object}

\item{r}{terra SpatRaster class elevation raster}

\item{echo}{(FALSE/TRUE) print progress to screen}
}
\value{
Vector of corrected topographic distances same length as nrow(x)
}
\description{
Calculates topographic corrected distance for a line object
}
\details{
This function corrects straight-line (euclidean) distances for topographic-slope effect.
}
\examples{
 library(sf)
 library(terra)
 
 # create example data
 elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
   names(elev) <- "elev"

 lns <- lapply(1:5, function(i) {
   p <- st_combine(st_as_sf(spatSample(elev, size=2, as.points=TRUE)))
   st_as_sf(st_cast(p, "LINESTRING")) }) 
 lns <- do.call(rbind, lns) 
  
  plot(elev)
    plot(st_geometry(lns), add=TRUE)
      
 # Calculate topographical distance  
 ( tdist <- topo.distance(lns, elev) )
 ( lgt <- as.numeric(st_length(lns)) ) 
 
 # Increase in corrected distance
 tdist - lgt
 
 # Percent increase in corrected distance
 ((tdist - lgt) / lgt) * 100

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
