% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{raw_clustering}
\alias{raw_clustering}
\alias{pair_counts}
\title{Clustering of pairs}
\usage{
raw_clustering(mat, wrap = TRUE, use_8_nb = FALSE)

pair_counts(mat, wrap = TRUE, use_8_nb = FALSE, prop = TRUE)
}
\arguments{
\item{mat}{A matrix, usually with discrete values (logical, integers, etc.)}

\item{wrap}{Whether space should be considered to wrap at the edges}

\item{use_8_nb}{Set to \code{TRUE} to use an 8-way neighborhood. The default is set
to FALSE, which uses a 4-way neighborhood}

\item{prop}{Return the counts for all pairs in the matrix (FALSE), or
the proportions for each pair (out of all possible pairs)}
}
\value{
A vector with the requested clutering values for \code{raw_clustering},
    whose names are equal to each state (unique value) found in the
    original matrix, preceded by 'clust_' (to make sure names are
    compatible with other functions).

 \code{pair_counts} returns the counts of pairs of states in the matrix,
    or the proportion of each pair, depending on the value of \code{prop}
}
\description{
Compute the number of pairs of neighbor cells in a landscape and derive 
  from it clustering indices
}
\details{
The clustering of pairs is defined as the density of pairs, i.e.
    the proportion of all neighboring pairs of cells that share the same state, 
    divided by the null expectation given a random, homogeneous spatial structure.

  For example, let's consider a matrix with two states, 'a' and 'b'.
    \code{raw_clustering} will count all pairs of cells 'a-a' or 'b-b', and
    divide this by the total number of pairs. This proportion is then again
    divided by the probability of obtaining these proportion of pairs under
    the assumption of no spatial structure (random mixing of cells in the
    matrix). 

  Clustering is equal to one when there is no spatial structure. It is
    above one when two states are found next to each other (i.e. cluster)
    more than expected by chance. Values below one means that those two
    states tend to be neighbors less frequently than expected by chance. 

  If you are only interested in the proportion of pairs for each combination
    of states, you can use the function \code{pair_counts}, which returns
    a matrix with as many rows and columns as there are states in the matrix, and 
    contains the counts for all possible pairs of cells found in the matrix 
    (or their relative proportions).
}
\examples{

# The clustering of a random matrix is close to one
ls <- 100 # lattice size
mm <- matrix(sample(c("sp1", "sp2", "sp3", "sp4"), size = ls^2, replace = TRUE),
             nrow = ls, ncol = ls)
clust <- raw_clustering(mm, wrap = TRUE, use_8_nb = TRUE)
print(clust)

# Compute clustering along the gradient for the serengeti dataset
\donttest{

data(forestgap)
clust_indic <- compute_indicator(serengeti, raw_clustering,
                                 wrap = TRUE, use_8_nb = FALSE)
# The interesting one is the clustering of state 0 (FALSE in the original matrix),
# which corresponds to grassland pixels, which get more and more clustered with 
# increasing rainfall (see also ?generic_sews for how that compares with generic 
# indicators)
plot(clust_indic, along = serengeti.rain)

# Add null trend
clust_test <- indictest(clust_indic, nulln = 19)
plot(clust_test, along = serengeti.rain)

# Show the proportion of each pairs of states in the matrix... 
pair_counts(serengeti[[5]])

# ... or the total count
pair_counts(serengeti[[5]], prop = FALSE)

}

}
